<?php
// Include config file
require_once 'config.php';
 
// Define variables and initialize with empty values
$username = $password = "";
$username_err = $password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Check if username is empty
    if(empty(trim($_POST["username"]))){
        $username_err = 'Please enter username.';
    } else{
        $username = trim($_POST["username"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST['password']))){
        $password_err = 'Please enter your password.';
    } else{
        $password = trim($_POST['password']);
    }
    
    // Validate credentials
    if(empty($username_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT username, password, id, user_type, created_at, creator_ip, Profile_pic, created_by, creator_id, creator_name FROM user_stu WHERE username = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_username);
            
            // Set parameters
            $param_username = $username;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if username exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $username, $hashed_password, $id, $user_type, $created_at, $creator_ip, $Profile_pic, $created_by, $creator_id, $creator_name);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            /* Password is correct, so start a new session and
                            save the username to the session */
                            session_start();
                            $_SESSION['username'] = $username;      
                            $_SESSION['password'] = $password;      
                            $_SESSION['id'] = $id;      
                            $_SESSION['user_type'] = $user_type;      
                            $_SESSION['created_at'] = $created_at;      
                            $_SESSION['creator_ip'] = $creator_ip;      
                            $_SESSION['Profile_pic'] = $Profile_pic;      
                            $_SESSION['created_by'] = $created_by;      
                            $_SESSION['creator_id'] = $creator_id;      
                            $_SESSION['creator_name'] = $creator_name;      
                            header("location: blackboard.php");
                        } else{
                            // Display an error message if password is not valid
                            $password_err = 'The password you entered was not valid.';
                        }
                    }
                } else{
                    // Display an error message if username doesn't exist
                    $username_err = 'No account found with that username.';
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>
 
<!DOCTYPE html>
<html lang="en">
<head>
  <title>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</title>
  <style>
  
  /*----------------------------*/


  
   .login {
  border-radius:5px;
  background-color:#219cd1;
  margin:0 auto;
  max-width:100%;
 
}
.login-header {
  color:#fff;
  text-align:center;
  font-size:120%;
}
/* .login-header h1 {
   text-shadow: 0px 5px 15px #000; */
}
.login-form {
  border:.5px solid #fff;
  background:#4facff;
  border-radius:10px;
  box-shadow:0px 0px 10px #000;
}
.login-form h3 {
  text-align:left;
  margin-left:40px;
  color:#fff;
}
.login-form {
  box-sizing:border-box;
  padding-top:15px;
	padding-bottom:10%;
  margin:5% auto;
  text-align:center;
}
.login input[type="text"],
.login input[type="password"] {
  max-width:250px;
	width: 60%;
  line-height:2em;
  font-family: 'Ubuntu', sans-serif;
  margin:1em 2em;
  border-radius:5px;
  border:2px solid #f2f2f2;
  outline:none;
  padding-left:0px;
}
.login-form input[type="button"] {
  height:30px;
  width:65px;
  background:#fff;
  border:2px solid #f2f2f2;
  border-radius:20px;
  color: slategrey;
  text-transform:uppercase;
  font-family: 'Ubuntu', sans-serif;
  cursor:pointer;
}

#log{
  height:30px;
  width:68px;
   font-size:xx-small;
  background:#fff;
  border:2px solid #f2f2f2;
  border-radius:1px;
  color: slategrey;
  cursor:pointer;
}

.no-access {
  color:black;
  text-decoration:underline;
  cursor:pointer;
}
  

/*Media Querie*/
@media only screen and (min-width : 100px) and (max-width : 530px){
  .login-form h3 {
    text-align:center;
    margin:0;
  }
  .sign-up, .no-access {
    margin:10px 0;
  }
  .login-button {
    margin-bottom:100px;
  }
}











  
.form {
  position: relative;
  z-index: 1;
  background: #FFFFFF;
  max-width: 360px;
  margin: 0 auto 100px;
  padding: 45px;
  text-align: center;
  box-shadow: 0 0 20px 0 rgba(0, 0, 0, 0.2), 0 5px 5px 0 rgba(0, 0, 0, 0.24);
}
#form {
  position: relative;
  z-index: 1;
  background: #FFFFFF;
  max-width: 360px;
  max-height: 340px;
  margin: 0 auto 100px;
  padding: 35px;
  text-align: center;
  box-shadow: 0 0 20px 0 rgba(0, 0, 0, 0.2), 0 5px 5px 0 rgba(0, 0, 0, 0.24);
}
.form input {
  font-family: "Roboto", sans-serif;
  outline: 0;
  background: #f2f2f2;
  width: 100%;
  border: 0;
  margin: 0 0 15px;
  padding: 15px;
  box-sizing: border-box;
  font-size: 14px;
}
.form button {
  font-family: "Roboto", sans-serif;
  text-transform: uppercase;
  outline: 0;
  background: #4CAF50;
  width: 100%;
  border: 0;
  padding: 15px;
  color: #FFFFFF;
  font-size: 14px;
  -webkit-transition: all 0.3 ease;
  transition: all 0.3 ease;
  cursor: pointer;
}
.form button:hover,.form button:active,.form button:focus {
  background: #43A047;
}
.form .message {
  margin: 15px 0 0;
  color: #b3b3b3;
  font-size: 12px;
}
.form .message a {
  color: #4CAF50;
  text-decoration: none;
}
.form .register-form {
  display: none;
}
.container {
  position: relative;
  z-index: 1;
  max-width: 300px;
  margin: 0 auto;
}
.container:before, .container:after {
  content: "";
  display: block;
  clear: both;
}
.container .info {
  margin: 50px auto;
  text-align: center;
}
.container .info h1 {
  margin: 0 0 15px;
  padding: 0;
  font-size: 36px;
  font-weight: 300;
  color: #1a1a1a;
}
.container .info span {
  color: #4d4d4d;
  font-size: 12px;
}
.container .info span a {
  color: #000000;
  text-decoration: none;
}
.container .info span .fa {
  color: #EF3B3A;
}

  
  
  
  
  
  
  
  
  
  
 /*--------------------------------------------*/ 
  
  
  
  
  
  
  
  
  
  
  
  
 #normal {
    width: 100%;
    padding: 2px 2px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    border-radius: 0px;
    box-sizing: border-box;
 }
  
  
input[type=text], select {
    width: 50%;
    padding: 2px 2px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
}

input[type=submit] {
    width: 50%;
    background-color: #cec35e;
    color: white;
	font-size: 18px;
	font-family:"Letter Gothic Std";
	font-weight:bold;
    padding: 12px 20px;
    margin: 8px 0;
    border: 2px solid white;
    border-radius: 4px;
    cursor: pointer;
}

input[type=submit]:hover {
color: white;
    background-color: white;
	color:#cec35e;
	border: 2px solid #cec35e;
}

.veer_css {
    height:286px;
    border-radius: 0px;
    background-color:#b3e5a0;
    padding: 2px;
}

#vir{
    width: 50%;
    padding: 2px 2px;
    margin: 8px 0;
    display: inline-block;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
}

@import url(https://fonts.googleapis.com/css?family=Roboto:300);
</style>








<meta name="description" content="toyam securities management pvt ltd Ranchi." />
<meta name="keywords" />
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="bootstrap.min.css">
  <script src="jquery.min.js"></script>
  <script src="bootstrap.min.js"></script>

  <link rel="stylesheet" href="style_index.css">
   

<link rel="shortcut icon" href="toyam.png" />
<link rel="apple-touch-icon" sizes="152x152" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="120x120" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="76x76" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="60x60" href="toyam.png"/>
</head>
<body>



<nav class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>                        
      </button>
    </div>
    <div class="collapse navbar-collapse" id="myNavbar">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php">Home</a></li>
        <li><a class="not-active" href="#"id="myBtn">BC Login</a></li>
     </ul>
      <ul class="nav navbar-nav navbar-right">
        <li><a href="student_login.php"><span class="glyphicon glyphicon-log-in"></span> Student Login</a></li>
      </ul>
    </div>
  </div>
</nav>


<div class="jumbotron" style="padding:0;">
<!===============================================================>
<div class="container-fluid bg-3 text-center" style="background-color:#dbd895;//#cec35e//DAA520">    
  <div class="row">

<br>
<div class="col-sm-2">
  <div class="container text-center">
    <img id="home" src="toyam.png">
  </div>
</div>
<div class="col-sm-8">
  <div class="container text-center">
	
     <p><font size="6" color="black" face="Orator Std"><strong>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</strong></font></p>
   
	
  </div>
</div>
<div class="col-sm-2">
  <div class="container text-center">
  
    <font size="2"color="white" face="Goudy Old Style">Toyam Securities and Facility Management Pvt. Ltd.</font>
                 <BR>
	<font size="2" color="white" face="Goudy Old Style">C/O- Executive Internet Cafe</font>
	<font size="2" color="white" face="Goudy Old Style">Ratu Chatti, P.O_+P.S- Ratu</font>
        <font size="2" color="white" face="Goudy Old Style">Pin-835222</font>
        <font size="2" color="white" face="Goudy Old Style">Dist.- Ranchi (JHARKHAND)</font>
  </div>
</div>

    </div>
  </div>

</div>













<div class="container-fluid bg-3 text-center">    
  
 <div class="row">
 
    <div class="col-sm-3">
	<center>
        
	
	<a class="two" href="contact_us.php">CONTACT US</a>
	<br>
	<a class="two" href="our_branches.php">BRANCHES</a>
	<br>
	<a class="two" href="nearest_center.php">NEAREST CENTER</a>
	<br>
	<a class="two" href="about_us.php">ABOUT US</a>
	<br>
	<a class="two" href="http://www.blog.toyamservices.com">OUR BLOG</a>
	<br>
	
	
	</center>
    </div>
			
    <div class="col-sm-6"> 
	
	<center>


<!-- Contact -->



  <div class="w3-light-grey w3-padding-xlarge w3-padding-0 w3-margin-top" id="contact" style="border: 2px solid #000000;width:58%;background-color:#77cc6D;">
  
<h3><font color="white" face="Letter Gothic Std"><b>STUDENT LOGIN</b></font></h3>

<div class="veer_css">

<div class="login-page">
  <div id="form"  style="height:280px;">
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            
                
                <input id="normal" type="text" name="username" value="<?php echo $username; ?>" placeholder="username">
                <span class="help-block"><?php echo $username_err; ?></span>
               <br>
                
                <input id="normal" type="password" name="password" placeholder="password">
                <span class="help-block"><?php echo $password_err; ?></span>
               <br>
                <input type="submit" class="btn btn-primary" value="Submit" style="font-size:xx-small;">
            
         </form>


  </div>
</div>
  
  
</div>

</div>
    

  








</center>
	
    </div>
	
    
	
    <div class="col-sm-3">
	
<center>
<div class="div1"><font color="white"><b>NEWS/UPDATES</b></font>
<BR>

<marquee direction="up" scrollamount="3" bgcolor="white" height="230" width="220" onmouseover="this.stop()" onmouseout="this.start()">

<a class="three" href="">
<p>&#9899;updates</p>
<p>&#9899;updates</p>
<p>&#9899;updates</p>
<p>&#9899;updates</p>

</a>
</marquee>

</div>


</center>
    </div>
  </div>
</div>

<br>

<footer class="container-fluid text-center">
<font color="white">
  <h5>
  Powered by&nbsp;
  <b></i><a href="http://www.vbpwebsoft.com"><font color="white">VBP Websoft</font></a></i></b>
  </h5>

<h6>Copyright &nbsp;&copy;TOYAM SECURITY & FACILITY MANAGEMENT PVT. LTD.&reg;
&nbsp; All Rights Reserved.
</h6></font></footer>






<script>
//student login

$('.message a').click(function(){
   $('form').animate({height: "toggle", opacity: "toggle"}, "slow");
});









// Get the modal
var modal = document.getElementById('myModal');

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal 
btn.onclick = function() {
    modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
    modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}
</script>
</script>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/59ae3493c28eca75e461e253/default';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->




	
</body>
</html>